/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import ws.hypha.ghastmaster.bukkit.Metrics;
import ws.hypha.ghastmaster.commands.CMDGhastMaster;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.listeners.BuildListener;
import ws.hypha.ghastmaster.listeners.FeedingListener;
import ws.hypha.ghastmaster.listeners.SpawnListener;
import ws.hypha.ghastmaster.listeners.VehicleListener;
import ws.hypha.ghastmaster.managers.SpeedManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class GhastMaster
extends JavaPlugin {
    private DefaultConfig config;
    private SpeedManager speedManager;

    public void onEnable() {
        long current = System.currentTimeMillis();
        this.enableBStats();
        this.loadConfigurations();
        this.initializeManagers();
        this.registerListeners();
        this.registerCommands();
        this.getLogger().info("GhastMaster activated! Starting took " + (System.currentTimeMillis() - current) + " ms.");
    }

    public void onDisable() {
        if (this.speedManager != null) {
            this.speedManager.cleanup();
        }
        this.getLogger().info("GhastMaster deactivated!");
    }

    private void enableBStats() {
        int pluginId = 26200;
        new Metrics(this, pluginId);
    }

    private void loadConfigurations() {
        this.saveDefaultConfig();
        this.config = new DefaultConfig(this);
        this.config.reload();
    }

    private void initializeManagers() {
        this.speedManager = new SpeedManager((Plugin)this, this.config);
    }

    private void registerListeners() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new BuildListener(this.config), (Plugin)this);
        pm.registerEvents((Listener)new SpawnListener(this.config), (Plugin)this);
        pm.registerEvents((Listener)new VehicleListener((Plugin)this, this.speedManager), (Plugin)this);
        pm.registerEvents((Listener)new FeedingListener(this.speedManager), (Plugin)this);
    }

    private void registerCommands() {
        MessageSender messageSender = new MessageSender(this.config);
        this.getCommand("ghastmaster").setExecutor((CommandExecutor)new CMDGhastMaster(messageSender, this.config));
    }

    public SpeedManager getSpeedManager() {
        return this.speedManager;
    }
}

