/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.config;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DefaultConfig {
    private static final String CONFIG = "Config.";
    private static final String PREFIX = "Config.Prefix.";
    private static final String SETTING = "Config.Settings.";
    private final JavaPlugin plugin;
    private FileConfiguration cfg;

    public DefaultConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.cfg = plugin.getConfig();
    }

    public String getPluginPrefix() {
        return this.cfg.getString("Config.Prefix.plugin-prefix");
    }

    public String getMessage(TextKey textkey) {
        return this.cfg.getString(textkey.key);
    }

    public double getHappyGhastMountedSpeedPercent(int passengerCount) {
        return this.cfg.getDouble(SETTING + passengerCount + "-passenger-happy-ghast-speed-percent");
    }

    public double getHappyGhastIdleSpeedPercent() {
        return this.cfg.getDouble("Config.Settings.idle-happy-ghast-speed-percent");
    }

    public double getSpeedLevelPercent(int level) {
        if (level == 0) {
            return 100.0;
        }
        return this.cfg.getDouble("Config.Settings.speed-level-" + level + "-percent");
    }

    public double getBoostSpeedPercent() {
        return this.cfg.getDouble("Config.Settings.boost-speed-percent");
    }

    public int getSpeedLevelDuration(int level) {
        return this.cfg.getInt("Config.Settings.speed-level-" + level + "-duration");
    }

    public int getBoostDuration() {
        return this.cfg.getInt("Config.Settings.boost-duration");
    }

    public int getBoostCooldown() {
        return this.cfg.getInt("Config.Settings.boost-cooldown");
    }

    public boolean getAnyPassengerCanFeed() {
        return this.cfg.getBoolean("Config.Settings.any-passenger-can-feed");
    }

    public boolean getShowSpeedHud() {
        return this.cfg.getBoolean("Config.Settings.show-speed-hud");
    }

    public int getHudUpdateIntervalTicks() {
        return this.cfg.getInt("Config.Settings.hud-update-interval-ticks");
    }

    public boolean getBuildOnHappyGhastEnabled() {
        return this.cfg.getBoolean("Config.Settings.build-on-happy-ghast-enabled");
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.cfg = this.plugin.getConfig();
    }

    public static enum TextKey {
        RELOADED_CONFIG("reloaded-config");

        private final String key;

        private TextKey(String key) {
            this.key = "Config.Messages." + key;
        }
    }
}

