/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import lombok.Generated;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import ws.hypha.ghastmaster.config.DefaultConfig;

public class SpawnListener
implements Listener {
    private final DefaultConfig config;

    @EventHandler
    private void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof HappyGhast)) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)livingEntity;
        double speedPercent = this.config.getHappyGhastIdleSpeedPercent();
        double defaultHappyGhastSpeed = 0.05;
        double speed = Math.max(0.0, Math.min(1.0, speedPercent / 100.0 * defaultHappyGhastSpeed));
        happyGhast.getAttribute(Attribute.FLYING_SPEED).setBaseValue(speed);
    }

    @Generated
    public SpawnListener(DefaultConfig config) {
        this.config = config;
    }
}

