/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.FreeModeManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class CMDGhastMaster
implements CommandExecutor,
TabCompleter {
    private final MessageSender messageSender;
    private final DefaultConfig config;
    private final FreeModeManager freeModeManager;

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length > 0) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "reload": {
                    this.config.reload();
                    this.messageSender.sendIfNotVoid(sender, DefaultConfig.TextKey.RELOADED_CONFIG);
                    return true;
                }
                case "free": {
                    return this.handleFreeCommand(sender);
                }
            }
            return false;
        }
        return false;
    }

    private boolean handleFreeCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.messageSender.sendMessage(sender, this.config.getText("command-players-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("ghastmaster.free")) {
            this.messageSender.sendMessage((CommandSender)player, this.config.getText("no-permission-free"));
            return true;
        }
        this.freeModeManager.enterFreeMode(player);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("reload", "free");
            for (String subcommand : subcommands) {
                if (!subcommand.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                if (subcommand.equals("reload") && sender.hasPermission("ghastmaster.reload")) {
                    completions.add(subcommand);
                    continue;
                }
                if (!subcommand.equals("free") || !sender.hasPermission("ghastmaster.free")) continue;
                completions.add(subcommand);
            }
        }
        return completions;
    }

    @Generated
    public CMDGhastMaster(MessageSender messageSender, DefaultConfig config, FreeModeManager freeModeManager) {
        this.messageSender = messageSender;
        this.config = config;
        this.freeModeManager = freeModeManager;
    }
}

