/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.FreeModeManager;
import ws.hypha.ghastmaster.managers.OwnershipManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class HarnessListener
implements Listener {
    private final Plugin plugin;
    private final OwnershipManager ownershipManager;
    private final FreeModeManager freeModeManager;
    private final MessageSender messageSender;

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!this.ownershipManager.isOwnershipEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (!(entity instanceof HappyGhast)) {
            return;
        }
        HappyGhast ghast = (HappyGhast)entity;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.freeModeManager.isInFreeMode(player)) {
            this.handleFreeModeInteraction(event, ghast, player);
            return;
        }
        if (this.isHarness(itemInHand)) {
            this.handleHarnessPlacement(event, ghast, player, itemInHand);
        } else if (this.ownershipManager.isOwned(ghast)) {
            boolean isFirstMount;
            boolean isMountingAttempt;
            boolean bl = isMountingAttempt = itemInHand == null || itemInHand.getType() == Material.AIR || !this.isHarness(itemInHand);
            if (isMountingAttempt && (isFirstMount = ghast.getPassengers().isEmpty()) && !this.ownershipManager.isOwner(ghast, player)) {
                this.ownershipManager.handleUnauthorizedAccess(ghast, player, "mount");
                event.setCancelled(true);
                return;
            }
        }
    }

    private void handleHarnessPlacement(PlayerInteractEntityEvent event, HappyGhast ghast, Player player, ItemStack harness) {
        if (!player.hasPermission("ghastmaster.harness.place")) {
            this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.NO_PERMISSION_HARNESS);
            event.setCancelled(true);
            return;
        }
        if (this.ownershipManager.isFree(ghast)) {
            this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_HARNESSED_FREE);
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (!this.ownershipManager.isOwned(ghast) && !this.ownershipManager.isFree(ghast)) {
                this.ownershipManager.setOwner(ghast, player);
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_OWNERSHIP_GAINED);
            }
        }, 1L);
    }

    private void handleFreeModeInteraction(PlayerInteractEntityEvent event, HappyGhast ghast, Player player) {
        event.setCancelled(true);
        this.freeModeManager.exitFreeMode(player);
        if (!this.ownershipManager.canFree(ghast, player)) {
            if (this.ownershipManager.isFree(ghast)) {
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_ALREADY_FREE);
            } else {
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.CANNOT_FREE_GHAST);
            }
            return;
        }
        this.ownershipManager.markAsFree(ghast);
        ghast.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, ghast.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
        ghast.getWorld().playSound(ghast.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_FREED_SUCCESS);
    }

    private boolean isHarness(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        try {
            return item.getType() == Material.valueOf((String)"HARNESS");
        }
        catch (IllegalArgumentException e) {
            return item.getType().name().toLowerCase().contains("harness");
        }
    }

    @Generated
    public HarnessListener(Plugin plugin, OwnershipManager ownershipManager, FreeModeManager freeModeManager, MessageSender messageSender) {
        this.plugin = plugin;
        this.ownershipManager = ownershipManager;
        this.freeModeManager = freeModeManager;
        this.messageSender = messageSender;
    }
}

