/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.managers;

import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.ParticleManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class OwnershipManager {
    private final Plugin plugin;
    private final DefaultConfig config;
    private final MessageSender messageSender;
    private ParticleManager particleManager;
    private static final String OWNER_KEY = "ghastmaster_owner";
    private static final String OWNED_KEY = "ghastmaster_owned";
    private static final String FREE_KEY = "ghastmaster_free";

    public OwnershipManager(Plugin plugin, DefaultConfig config, MessageSender messageSender) {
        this.plugin = plugin;
        this.config = config;
        this.messageSender = messageSender;
    }

    public void setParticleManager(ParticleManager particleManager) {
        this.particleManager = particleManager;
    }

    private NamespacedKey getOwnerKey() {
        return new NamespacedKey(this.plugin, OWNER_KEY);
    }

    private NamespacedKey getOwnedKey() {
        return new NamespacedKey(this.plugin, OWNED_KEY);
    }

    private NamespacedKey getFreeKey() {
        return new NamespacedKey(this.plugin, FREE_KEY);
    }

    public void setOwner(HappyGhast ghast, Player owner) {
        if (this.isFree(ghast)) {
            return;
        }
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.set(this.getOwnerKey(), PersistentDataType.STRING, (Object)owner.getUniqueId().toString());
        dataContainer.set(this.getOwnedKey(), PersistentDataType.BOOLEAN, (Object)true);
    }

    public void removeOwner(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.remove(this.getOwnerKey());
        dataContainer.remove(this.getOwnedKey());
    }

    public UUID getOwnerUUID(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        if (!dataContainer.has(this.getOwnedKey(), PersistentDataType.BOOLEAN)) {
            return null;
        }
        String ownerString = (String)dataContainer.get(this.getOwnerKey(), PersistentDataType.STRING);
        if (ownerString == null) {
            return null;
        }
        try {
            return UUID.fromString(ownerString);
        }
        catch (IllegalArgumentException e) {
            this.removeOwner(ghast);
            return null;
        }
    }

    public boolean isOwned(HappyGhast ghast) {
        return this.getOwnerUUID(ghast) != null;
    }

    public boolean isOwner(HappyGhast ghast, Player player) {
        UUID ownerUUID = this.getOwnerUUID(ghast);
        return ownerUUID != null && ownerUUID.equals(player.getUniqueId());
    }

    public void handleUnauthorizedAccess(HappyGhast ghast, Player player, String action) {
        player.playSound(player.getLocation(), Sound.ENTITY_GHAST_SCREAM, 1.0f, 1.0f);
        ghast.getWorld().playSound(ghast.getLocation(), Sound.ENTITY_GHAST_SCREAM, 1.0f, 1.0f);
        Vector knockback = player.getLocation().toVector().subtract(ghast.getLocation().toVector()).normalize().multiply(this.config.getDouble("ownership-knockback-strength", 1.5));
        player.setVelocity(knockback);
        String ownerName = this.getOwnerName(ghast);
        String message = this.config.getText("unauthorized-access");
        if (message != null) {
            message = message.replace("%ACTION%", action).replace("%OWNER%", ownerName != null ? ownerName : "Unknown");
            this.messageSender.sendMessage((CommandSender)player, message);
        } else {
            String fallbackMessage = this.config.getPluginPrefix() + "&cYou cannot " + action + " this Happy Ghast! It belongs to &e" + (ownerName != null ? ownerName : "Unknown") + "&c.";
            this.messageSender.sendMessage((CommandSender)player, fallbackMessage);
        }
    }

    private String getOwnerName(HappyGhast ghast) {
        UUID ownerUUID = this.getOwnerUUID(ghast);
        if (ownerUUID == null) {
            return null;
        }
        Player owner = this.plugin.getServer().getPlayer(ownerUUID);
        if (owner != null) {
            return owner.getName();
        }
        return this.plugin.getServer().getOfflinePlayer(ownerUUID).getName();
    }

    public boolean isOwnershipEnabled() {
        return this.config.getBoolean("ownership-system-enabled", true);
    }

    public void markAsFree(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.set(this.getFreeKey(), PersistentDataType.BOOLEAN, (Object)true);
        this.removeOwner(ghast);
        if (this.particleManager != null) {
            this.particleManager.startFreeGhastParticles(ghast);
        }
    }

    public boolean isFree(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        return dataContainer.has(this.getFreeKey(), PersistentDataType.BOOLEAN) && Boolean.TRUE.equals(dataContainer.get(this.getFreeKey(), PersistentDataType.BOOLEAN));
    }

    public void removeFreeStatus(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.remove(this.getFreeKey());
        if (this.particleManager != null) {
            this.particleManager.stopFreeGhastParticles(ghast);
        }
    }

    public boolean canFree(HappyGhast ghast, Player player) {
        if (this.isFree(ghast)) {
            return false;
        }
        if (!this.isOwned(ghast)) {
            return true;
        }
        return this.isOwner(ghast, player);
    }
}

