/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import ws.hypha.ghastmaster.bukkit.Metrics;
import ws.hypha.ghastmaster.commands.CMDFreeGhast;
import ws.hypha.ghastmaster.commands.CMDGhastMaster;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.listeners.BuildListener;
import ws.hypha.ghastmaster.listeners.FeedingListener;
import ws.hypha.ghastmaster.listeners.HarnessListener;
import ws.hypha.ghastmaster.listeners.SpawnListener;
import ws.hypha.ghastmaster.listeners.VehicleListener;
import ws.hypha.ghastmaster.managers.FreeModeManager;
import ws.hypha.ghastmaster.managers.OwnershipManager;
import ws.hypha.ghastmaster.managers.ParticleManager;
import ws.hypha.ghastmaster.managers.SpeedManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class GhastMaster
extends JavaPlugin {
    private DefaultConfig config;
    private SpeedManager speedManager;
    private OwnershipManager ownershipManager;
    private FreeModeManager freeModeManager;
    private ParticleManager particleManager;
    private MessageSender messageSender;

    public void onEnable() {
        long current = System.currentTimeMillis();
        this.enableBStats();
        this.loadConfigurations();
        this.initializeManagers();
        this.registerListeners();
        this.registerCommands();
        this.getLogger().info("GhastMaster activated! Starting took " + (System.currentTimeMillis() - current) + " ms.");
    }

    public void onDisable() {
        if (this.speedManager != null) {
            this.speedManager.cleanup();
        }
        if (this.freeModeManager != null) {
            this.freeModeManager.cleanup();
        }
        if (this.particleManager != null) {
            this.particleManager.cleanup();
        }
        if (this.ownershipManager != null) {
            this.ownershipManager.cleanupUnclaimMode();
        }
        this.getLogger().info("GhastMaster deactivated!");
    }

    private void enableBStats() {
        int pluginId = 26200;
        new Metrics(this, pluginId);
    }

    private void loadConfigurations() {
        this.saveDefaultConfig();
        this.config = new DefaultConfig(this);
        this.config.reload();
    }

    private void initializeManagers() {
        this.messageSender = new MessageSender(this.config);
        this.speedManager = new SpeedManager((Plugin)this, this.config);
        this.ownershipManager = new OwnershipManager((Plugin)this, this.config, this.messageSender);
        this.freeModeManager = new FreeModeManager((Plugin)this, this.config, this.messageSender);
        this.particleManager = new ParticleManager((Plugin)this, this.config, this.ownershipManager);
        this.ownershipManager.setParticleManager(this.particleManager);
    }

    private void registerListeners() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new BuildListener(this.config), (Plugin)this);
        pm.registerEvents((Listener)new SpawnListener(this.config, this.ownershipManager, this.particleManager), (Plugin)this);
        pm.registerEvents((Listener)new VehicleListener((Plugin)this, this.speedManager, this.ownershipManager), (Plugin)this);
        pm.registerEvents((Listener)new FeedingListener(this.speedManager), (Plugin)this);
        pm.registerEvents((Listener)new HarnessListener((Plugin)this, this.ownershipManager, this.freeModeManager, this.messageSender, this.config), (Plugin)this);
    }

    private void registerCommands() {
        CMDGhastMaster ghastmasterCmd = new CMDGhastMaster(this.messageSender, this.config, this.freeModeManager, this.ownershipManager);
        this.getCommand("ghastmaster").setExecutor((CommandExecutor)ghastmasterCmd);
        this.getCommand("ghastmaster").setTabCompleter((TabCompleter)ghastmasterCmd);
        this.getCommand("freeghast").setExecutor((CommandExecutor)new CMDFreeGhast(this.messageSender, this.config, this.freeModeManager));
    }

    public SpeedManager getSpeedManager() {
        return this.speedManager;
    }

    public OwnershipManager getOwnershipManager() {
        return this.ownershipManager;
    }
}

