/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.config;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DefaultConfig {
    private static final String CONFIG = "Config.";
    private static final String PREFIX = "Config.Prefix.";
    private static final String SETTING = "Config.Settings.";
    private final JavaPlugin plugin;
    private FileConfiguration cfg;

    public DefaultConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.cfg = plugin.getConfig();
    }

    public String getPluginPrefix() {
        return this.cfg.getString("Config.Prefix.plugin-prefix");
    }

    public String getMessage(TextKey textkey) {
        return this.cfg.getString(textkey.key);
    }

    public double getHappyGhastMountedSpeedPercent(int passengerCount) {
        return this.cfg.getDouble(SETTING + passengerCount + "-passenger-happy-ghast-speed-percent");
    }

    public double getHappyGhastIdleSpeedPercent() {
        return this.cfg.getDouble("Config.Settings.idle-happy-ghast-speed-percent");
    }

    public double getSpeedLevelPercent(int level) {
        if (level == 0) {
            return 100.0;
        }
        return this.cfg.getDouble("Config.Settings.speed-level-" + level + "-percent");
    }

    public double getBoostSpeedPercent() {
        return this.cfg.getDouble("Config.Settings.boost-speed-percent");
    }

    public int getSpeedLevelDuration(int level) {
        return this.cfg.getInt("Config.Settings.speed-level-" + level + "-duration");
    }

    public int getBoostDuration() {
        return this.cfg.getInt("Config.Settings.boost-duration");
    }

    public int getBoostCooldown() {
        return this.cfg.getInt("Config.Settings.boost-cooldown");
    }

    public boolean getAnyPassengerCanFeed() {
        return this.cfg.getBoolean("Config.Settings.any-passenger-can-feed");
    }

    public boolean getShowSpeedHud() {
        return this.cfg.getBoolean("Config.Settings.show-speed-hud");
    }

    public int getHudUpdateIntervalTicks() {
        return this.cfg.getInt("Config.Settings.hud-update-interval-ticks");
    }

    public boolean getBuildOnHappyGhastEnabled() {
        return this.cfg.getBoolean("Config.Settings.build-on-happy-ghast-enabled");
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.cfg.getBoolean(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.cfg.getDouble(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public String getText(String path) {
        return this.cfg.getString("Config.Messages." + path);
    }

    public long getLong(String path, long defaultValue) {
        return this.cfg.getLong(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.cfg.getInt(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.cfg = this.plugin.getConfig();
    }

    public static enum TextKey {
        RELOADED_CONFIG("reloaded-config"),
        UNAUTHORIZED_ACCESS("unauthorized-access"),
        GHAST_ALREADY_HARNESSED("ghast-already-harnessed"),
        GHAST_OWNERSHIP_CLAIMED("ghast-ownership-claimed"),
        GHAST_OWNERSHIP_GAINED("ghast-ownership-gained"),
        GHAST_OWNERSHIP_REMOVED("ghast-ownership-removed"),
        NO_PERMISSION_HARNESS("no-permission-harness"),
        CANNOT_REMOVE_HARNESS_WITH_PASSENGERS("cannot-remove-harness-with-passengers"),
        FREE_MODE_ENTERED("free-mode-entered"),
        FREE_MODE_TIMEOUT("free-mode-timeout"),
        GHAST_FREED_SUCCESS("ghast-freed-success"),
        GHAST_ALREADY_FREE("ghast-already-free"),
        CANNOT_FREE_GHAST("cannot-free-ghast"),
        GHAST_HARNESSED_FREE("ghast-harnessed-free"),
        NO_PERMISSION_FREE("no-permission-free"),
        COMMAND_PLAYERS_ONLY("command-players-only"),
        OWNERSHIP_SYSTEM_DISABLED("ownership-system-disabled"),
        NO_PERMISSION_UNCLAIM("no-permission-unclaim"),
        NO_PERMISSION_UNCLAIM_ADMIN("no-permission-unclaim-admin"),
        NO_GHAST_IN_SIGHT("no-ghast-in-sight"),
        CANNOT_UNCLAIM_NOT_OWNER("cannot-unclaim-not-owner"),
        CANNOT_UNCLAIM_FREE_GHAST("cannot-unclaim-free-ghast"),
        GHAST_ALREADY_UNCLAIMED("ghast-already-unclaimed"),
        CANNOT_UNCLAIM_GHAST("cannot-unclaim-ghast"),
        GHAST_UNCLAIMED_SUCCESS("ghast-unclaimed-success"),
        GHAST_ADMIN_UNCLAIMED_SUCCESS("ghast-admin-unclaimed-success"),
        UNCLAIM_MODE_ENTERED("unclaim-mode-entered"),
        ADMIN_UNCLAIM_MODE_ENTERED("admin-unclaim-mode-entered"),
        UNCLAIM_MODE_TIMEOUT("unclaim-mode-timeout"),
        ADMIN_UNCLAIM_CONFIRMATION_REQUIRED("admin-unclaim-confirmation-required"),
        NO_PENDING_UNCLAIM("no-pending-unclaim"),
        GHAST_NO_LONGER_EXISTS("ghast-no-longer-exists");

        private final String key;

        private TextKey(String key) {
            this.key = "Config.Messages." + key;
        }
    }
}

