/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.FreeModeManager;
import ws.hypha.ghastmaster.managers.OwnershipManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class HarnessListener
implements Listener {
    private final Plugin plugin;
    private final OwnershipManager ownershipManager;
    private final FreeModeManager freeModeManager;
    private final MessageSender messageSender;
    private final DefaultConfig config;

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!this.ownershipManager.isOwnershipEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (!(entity instanceof HappyGhast)) {
            return;
        }
        HappyGhast ghast = (HappyGhast)entity;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.freeModeManager.isInFreeMode(player)) {
            this.handleFreeModeInteraction(event, ghast, player);
            return;
        }
        if (this.ownershipManager.isInUnclaimMode(player)) {
            this.handleUnclaimModeInteraction(event, ghast, player);
            return;
        }
        if (this.isHarness(itemInHand)) {
            this.handleHarnessPlacement(event, ghast, player, itemInHand);
        } else if (this.ownershipManager.isOwned(ghast)) {
            boolean isFirstMount;
            boolean isMountingAttempt;
            boolean bl = isMountingAttempt = itemInHand == null || itemInHand.getType() == Material.AIR || !this.isHarness(itemInHand);
            if (isMountingAttempt && (isFirstMount = ghast.getPassengers().isEmpty()) && !this.ownershipManager.isOwner(ghast, player)) {
                this.ownershipManager.handleUnauthorizedAccess(ghast, player, "mount");
                event.setCancelled(true);
                return;
            }
        }
    }

    private void handleHarnessPlacement(PlayerInteractEntityEvent event, HappyGhast ghast, Player player, ItemStack harness) {
        if (!player.hasPermission("ghastmaster.harness.place")) {
            this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.NO_PERMISSION_HARNESS);
            event.setCancelled(true);
            return;
        }
        if (this.ownershipManager.isFree(ghast)) {
            this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_HARNESSED_FREE);
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (!this.ownershipManager.isOwned(ghast) && !this.ownershipManager.isFree(ghast)) {
                this.ownershipManager.setOwner(ghast, player);
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_OWNERSHIP_GAINED);
            }
        }, 1L);
    }

    private void handleFreeModeInteraction(PlayerInteractEntityEvent event, HappyGhast ghast, Player player) {
        event.setCancelled(true);
        this.freeModeManager.exitFreeMode(player);
        if (!this.ownershipManager.canFree(ghast, player)) {
            if (this.ownershipManager.isFree(ghast)) {
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_ALREADY_FREE);
            } else {
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.CANNOT_FREE_GHAST);
            }
            return;
        }
        this.ownershipManager.markAsFree(ghast);
        ghast.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, ghast.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
        ghast.getWorld().playSound(ghast.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_FREED_SUCCESS);
    }

    private void handleUnclaimModeInteraction(PlayerInteractEntityEvent event, HappyGhast ghast, Player player) {
        event.setCancelled(true);
        boolean isAdminMode = this.ownershipManager.isInAdminUnclaimMode(player);
        this.ownershipManager.exitUnclaimMode(player);
        if (isAdminMode) {
            if (!this.ownershipManager.isOwned(ghast) && !this.ownershipManager.isFree(ghast)) {
                this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_ALREADY_UNCLAIMED);
                return;
            }
            if (this.ownershipManager.isOwned(ghast) && !this.ownershipManager.isOwner(ghast, player)) {
                String baseMessage;
                this.ownershipManager.setPendingConfirmation(player, ghast);
                String ownerName = "Unknown";
                UUID ownerUUID = this.ownershipManager.getOwnerUUID(ghast);
                if (ownerUUID != null) {
                    String name = this.plugin.getServer().getOfflinePlayer(ownerUUID).getName();
                    String string = ownerName = name != null ? name : ownerUUID.toString();
                }
                if ((baseMessage = this.config.getText("admin-unclaim-confirmation-required")) != null) {
                    baseMessage = baseMessage.replace("%OWNER%", ownerName);
                    TextComponent confirmButton = new TextComponent("[CLICK TO CONFIRM]");
                    confirmButton.setColor(ChatColor.YELLOW);
                    confirmButton.setBold(Boolean.valueOf(true));
                    confirmButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ghastmaster unclaim confirm"));
                    confirmButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to confirm unclaiming this ghast").create()));
                    this.messageSender.sendMessage((CommandSender)player, baseMessage);
                    TextComponent buttonMessage = new TextComponent("");
                    String prefix = this.config.getPluginPrefix();
                    if (prefix != null) {
                        buttonMessage.addExtra((BaseComponent)new TextComponent(prefix.replace("&", "\u00a7")));
                    }
                    buttonMessage.addExtra((BaseComponent)confirmButton);
                    player.spigot().sendMessage((BaseComponent)buttonMessage);
                }
                return;
            }
            String previousOwner = "none";
            if (this.ownershipManager.isOwned(ghast)) {
                UUID ownerUUID = this.ownershipManager.getOwnerUUID(ghast);
                if (ownerUUID != null) {
                    String name = this.plugin.getServer().getOfflinePlayer(ownerUUID).getName();
                    previousOwner = name != null ? name : ownerUUID.toString();
                }
            } else if (this.ownershipManager.isFree(ghast)) {
                previousOwner = "free";
            }
            this.ownershipManager.unclaimGhast(ghast);
            String message = this.config.getMessage(DefaultConfig.TextKey.GHAST_ADMIN_UNCLAIMED_SUCCESS);
            if (message != null) {
                message = message.replace("%PREVIOUS_OWNER%", previousOwner);
                this.messageSender.sendMessage((CommandSender)player, message);
            }
        } else {
            if (!this.ownershipManager.canUnclaim(ghast, player)) {
                if (this.ownershipManager.isOwned(ghast)) {
                    this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.CANNOT_UNCLAIM_NOT_OWNER);
                } else if (this.ownershipManager.isFree(ghast)) {
                    this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.CANNOT_UNCLAIM_FREE_GHAST);
                } else {
                    this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_ALREADY_UNCLAIMED);
                }
                return;
            }
            this.ownershipManager.unclaimGhast(ghast);
            this.messageSender.sendMessage((CommandSender)player, DefaultConfig.TextKey.GHAST_UNCLAIMED_SUCCESS);
        }
    }

    private boolean isHarness(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        try {
            return item.getType() == Material.valueOf((String)"HARNESS");
        }
        catch (IllegalArgumentException e) {
            return item.getType().name().toLowerCase().contains("harness");
        }
    }

    @Generated
    public HarnessListener(Plugin plugin, OwnershipManager ownershipManager, FreeModeManager freeModeManager, MessageSender messageSender, DefaultConfig config) {
        this.plugin = plugin;
        this.ownershipManager = ownershipManager;
        this.freeModeManager = freeModeManager;
        this.messageSender = messageSender;
        this.config = config;
    }
}

