/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import lombok.Generated;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.OwnershipManager;
import ws.hypha.ghastmaster.managers.ParticleManager;

public class SpawnListener
implements Listener {
    private final DefaultConfig config;
    private final OwnershipManager ownershipManager;
    private final ParticleManager particleManager;

    @EventHandler
    private void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof HappyGhast)) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)livingEntity;
        double speedPercent = this.config.getHappyGhastIdleSpeedPercent();
        double defaultHappyGhastSpeed = 0.05;
        double speed = Math.max(0.0, Math.min(1.0, speedPercent / 100.0 * defaultHappyGhastSpeed));
        happyGhast.getAttribute(Attribute.FLYING_SPEED).setBaseValue(speed);
        if (this.ownershipManager.isFree(happyGhast)) {
            this.particleManager.startFreeGhastParticles(happyGhast);
        }
    }

    @EventHandler
    private void onChunkLoad(ChunkLoadEvent event) {
        event.getChunk().getEntities();
        for (Entity entity : event.getChunk().getEntities()) {
            HappyGhast happyGhast;
            if (!(entity instanceof HappyGhast) || !this.ownershipManager.isFree(happyGhast = (HappyGhast)entity)) continue;
            this.particleManager.startFreeGhastParticles(happyGhast);
        }
    }

    @Generated
    public SpawnListener(DefaultConfig config, OwnershipManager ownershipManager, ParticleManager particleManager) {
        this.config = config;
        this.ownershipManager = ownershipManager;
        this.particleManager = particleManager;
    }
}

