/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import ws.hypha.ghastmaster.managers.OwnershipManager;
import ws.hypha.ghastmaster.managers.SpeedManager;

public class VehicleListener
implements Listener {
    private final Plugin plugin;
    private final SpeedManager speedManager;
    private final OwnershipManager ownershipManager;

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onVehicleEnter(VehicleEnterEvent event) {
        boolean isFirstMount;
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof HappyGhast)) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)vehicle;
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleEnter(happyGhast));
            return;
        }
        Player player = (Player)entity;
        if (this.ownershipManager.isOwnershipEnabled() && this.ownershipManager.isOwned(happyGhast) && (isFirstMount = happyGhast.getPassengers().isEmpty()) && !this.ownershipManager.isOwner(happyGhast, player)) {
            this.ownershipManager.handleUnauthorizedAccess(happyGhast, player, "mount");
            event.setCancelled(true);
            return;
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleEnter(happyGhast));
    }

    @EventHandler
    private void onVehicleExit(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof HappyGhast)) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)vehicle;
        LivingEntity livingEntity = event.getExited();
        if (!(livingEntity instanceof Player)) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleExit(happyGhast));
            return;
        }
        Player exitingPlayer = (Player)livingEntity;
        Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleExit(happyGhast));
    }

    @Generated
    public VehicleListener(Plugin plugin, SpeedManager speedManager, OwnershipManager ownershipManager) {
        this.plugin = plugin;
        this.speedManager = speedManager;
        this.ownershipManager = ownershipManager;
    }
}

