/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.ParticleManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class OwnershipManager {
    private final Plugin plugin;
    private final DefaultConfig config;
    private final MessageSender messageSender;
    private ParticleManager particleManager;
    private final Map<UUID, BukkitTask> playersInUnclaimMode = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Boolean> adminUnclaimMode = new HashMap<UUID, Boolean>();
    private final Map<UUID, UUID> pendingConfirmations = new HashMap<UUID, UUID>();
    private static final String OWNER_KEY = "ghastmaster_owner";
    private static final String OWNED_KEY = "ghastmaster_owned";
    private static final String FREE_KEY = "ghastmaster_free";

    public OwnershipManager(Plugin plugin, DefaultConfig config, MessageSender messageSender) {
        this.plugin = plugin;
        this.config = config;
        this.messageSender = messageSender;
    }

    public void setParticleManager(ParticleManager particleManager) {
        this.particleManager = particleManager;
    }

    private NamespacedKey getOwnerKey() {
        return new NamespacedKey(this.plugin, OWNER_KEY);
    }

    private NamespacedKey getOwnedKey() {
        return new NamespacedKey(this.plugin, OWNED_KEY);
    }

    private NamespacedKey getFreeKey() {
        return new NamespacedKey(this.plugin, FREE_KEY);
    }

    public void setOwner(HappyGhast ghast, Player owner) {
        if (this.isFree(ghast)) {
            return;
        }
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.set(this.getOwnerKey(), PersistentDataType.STRING, (Object)owner.getUniqueId().toString());
        dataContainer.set(this.getOwnedKey(), PersistentDataType.BOOLEAN, (Object)true);
    }

    public void removeOwner(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.remove(this.getOwnerKey());
        dataContainer.remove(this.getOwnedKey());
    }

    public UUID getOwnerUUID(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        if (!dataContainer.has(this.getOwnedKey(), PersistentDataType.BOOLEAN)) {
            return null;
        }
        String ownerString = (String)dataContainer.get(this.getOwnerKey(), PersistentDataType.STRING);
        if (ownerString == null) {
            return null;
        }
        try {
            return UUID.fromString(ownerString);
        }
        catch (IllegalArgumentException e) {
            this.removeOwner(ghast);
            return null;
        }
    }

    public boolean isOwned(HappyGhast ghast) {
        return this.getOwnerUUID(ghast) != null;
    }

    public boolean isOwner(HappyGhast ghast, Player player) {
        UUID ownerUUID = this.getOwnerUUID(ghast);
        return ownerUUID != null && ownerUUID.equals(player.getUniqueId());
    }

    public void handleUnauthorizedAccess(HappyGhast ghast, Player player, String action) {
        player.playSound(player.getLocation(), Sound.ENTITY_GHAST_SCREAM, 1.0f, 1.0f);
        ghast.getWorld().playSound(ghast.getLocation(), Sound.ENTITY_GHAST_SCREAM, 1.0f, 1.0f);
        Vector knockback = player.getLocation().toVector().subtract(ghast.getLocation().toVector()).normalize().multiply(this.config.getDouble("ownership-knockback-strength", 1.5));
        player.setVelocity(knockback);
        String ownerName = this.getOwnerName(ghast);
        String message = this.config.getText("unauthorized-access");
        if (message != null) {
            message = message.replace("%ACTION%", action).replace("%OWNER%", ownerName != null ? ownerName : "Unknown");
            this.messageSender.sendMessage((CommandSender)player, message);
        } else {
            String fallbackMessage = this.config.getPluginPrefix() + "&cYou cannot " + action + " this Happy Ghast! It belongs to &e" + (ownerName != null ? ownerName : "Unknown") + "&c.";
            this.messageSender.sendMessage((CommandSender)player, fallbackMessage);
        }
    }

    private String getOwnerName(HappyGhast ghast) {
        UUID ownerUUID = this.getOwnerUUID(ghast);
        if (ownerUUID == null) {
            return null;
        }
        Player owner = this.plugin.getServer().getPlayer(ownerUUID);
        if (owner != null) {
            return owner.getName();
        }
        return this.plugin.getServer().getOfflinePlayer(ownerUUID).getName();
    }

    public boolean isOwnershipEnabled() {
        return this.config.getBoolean("ownership-system-enabled", true);
    }

    public void markAsFree(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.set(this.getFreeKey(), PersistentDataType.BOOLEAN, (Object)true);
        this.removeOwner(ghast);
        if (this.particleManager != null) {
            this.particleManager.startFreeGhastParticles(ghast);
        }
    }

    public boolean isFree(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        return dataContainer.has(this.getFreeKey(), PersistentDataType.BOOLEAN) && Boolean.TRUE.equals(dataContainer.get(this.getFreeKey(), PersistentDataType.BOOLEAN));
    }

    public void removeFreeStatus(HappyGhast ghast) {
        PersistentDataContainer dataContainer = ghast.getPersistentDataContainer();
        dataContainer.remove(this.getFreeKey());
        if (this.particleManager != null) {
            this.particleManager.stopFreeGhastParticles(ghast);
        }
    }

    public boolean canFree(HappyGhast ghast, Player player) {
        if (this.isFree(ghast)) {
            return false;
        }
        if (!this.isOwned(ghast)) {
            return true;
        }
        return this.isOwner(ghast, player);
    }

    public void unclaimGhast(HappyGhast ghast) {
        this.removeOwner(ghast);
        if (this.particleManager != null) {
            this.particleManager.stopFreeGhastParticles(ghast);
        }
        this.removeFreeStatus(ghast);
    }

    public boolean canUnclaim(HappyGhast ghast, Player player) {
        if (this.isOwned(ghast)) {
            return this.isOwner(ghast, player);
        }
        return false;
    }

    public boolean canForceUnclaim(Player player) {
        return player.hasPermission("ghastmaster.unclaim.admin");
    }

    public void setPendingConfirmation(Player player, HappyGhast ghast) {
        this.pendingConfirmations.put(player.getUniqueId(), ghast.getUniqueId());
    }

    public void enterUnclaimMode(Player player) {
        UUID playerId = player.getUniqueId();
        this.exitUnclaimMode(player);
        BukkitTask timeoutTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            this.exitUnclaimMode(player);
            this.messageSender.sendMessage((CommandSender)player, this.config.getText("unclaim-mode-timeout"));
        }, this.config.getLong("unclaim-mode-timeout-ticks", 600L));
        this.playersInUnclaimMode.put(playerId, timeoutTask);
        this.adminUnclaimMode.put(playerId, false);
        this.messageSender.sendMessage((CommandSender)player, this.config.getText("unclaim-mode-entered"));
    }

    public void enterAdminUnclaimMode(Player player) {
        UUID playerId = player.getUniqueId();
        this.exitUnclaimMode(player);
        BukkitTask timeoutTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            this.exitUnclaimMode(player);
            this.messageSender.sendMessage((CommandSender)player, this.config.getText("unclaim-mode-timeout"));
        }, this.config.getLong("unclaim-mode-timeout-ticks", 600L));
        this.playersInUnclaimMode.put(playerId, timeoutTask);
        this.adminUnclaimMode.put(playerId, true);
        this.messageSender.sendMessage((CommandSender)player, this.config.getText("admin-unclaim-mode-entered"));
    }

    public void exitUnclaimMode(Player player) {
        UUID playerId = player.getUniqueId();
        BukkitTask task = this.playersInUnclaimMode.remove(playerId);
        this.adminUnclaimMode.remove(playerId);
        if (task != null) {
            task.cancel();
        }
    }

    public boolean isInUnclaimMode(Player player) {
        return this.playersInUnclaimMode.containsKey(player.getUniqueId());
    }

    public boolean isInAdminUnclaimMode(Player player) {
        return this.adminUnclaimMode.getOrDefault(player.getUniqueId(), false);
    }

    public boolean handleUnclaimConfirmation(Player player) {
        UUID playerId = player.getUniqueId();
        UUID ghastId = this.pendingConfirmations.remove(playerId);
        if (ghastId == null) {
            this.messageSender.sendMessage((CommandSender)player, this.config.getText("no-pending-unclaim"));
            return true;
        }
        HappyGhast ghast = this.findGhastByUUID(ghastId);
        if (ghast == null) {
            this.messageSender.sendMessage((CommandSender)player, this.config.getText("ghast-no-longer-exists"));
            return true;
        }
        String previousOwner = "none";
        if (this.isOwned(ghast)) {
            UUID ownerUUID = this.getOwnerUUID(ghast);
            if (ownerUUID != null && (previousOwner = this.plugin.getServer().getOfflinePlayer(ownerUUID).getName()) == null) {
                previousOwner = ownerUUID.toString();
            }
        } else if (this.isFree(ghast)) {
            previousOwner = "free";
        }
        this.unclaimGhast(ghast);
        String message = this.config.getText("ghast-admin-unclaimed-success");
        if (message != null) {
            message = message.replace("%PREVIOUS_OWNER%", previousOwner);
            this.messageSender.sendMessage((CommandSender)player, message);
        }
        return true;
    }

    private HappyGhast findGhastByUUID(UUID ghastId) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof HappyGhast) || !entity.getUniqueId().equals(ghastId)) continue;
                return (HappyGhast)entity;
            }
        }
        return null;
    }

    public void cleanupUnclaimMode() {
        for (BukkitTask task : this.playersInUnclaimMode.values()) {
            if (task == null) continue;
            task.cancel();
        }
        this.playersInUnclaimMode.clear();
        this.adminUnclaimMode.clear();
        this.pendingConfirmations.clear();
    }
}

