/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.utils;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import ws.hypha.ghastmaster.config.DefaultConfig;

public class MessageSender {
    private final DefaultConfig config;

    public MessageSender(DefaultConfig config) {
        this.config = config;
    }

    public void sendIfNotVoid(CommandSender sender, DefaultConfig.TextKey messageKey) {
        String message = this.config.getMessage(messageKey);
        if (!message.isBlank()) {
            message = message.replace("%PREFIX%", this.config.getPluginPrefix());
            sender.sendMessage(this.translateColors(message));
        }
    }

    public void sendMessage(CommandSender sender, String message) {
        if (message != null && !message.isBlank()) {
            message = message.replace("%PREFIX%", this.config.getPluginPrefix());
            sender.sendMessage(this.translateColors(message));
        }
    }

    public void sendMessage(CommandSender sender, DefaultConfig.TextKey messageKey) {
        this.sendIfNotVoid(sender, messageKey);
    }

    private String translateColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

