/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.SpeedManager;

public class FeedingListener
implements Listener {
    private final SpeedManager speedManager;
    private final DefaultConfig config;

    public FeedingListener(SpeedManager speedManager, DefaultConfig config) {
        this.speedManager = speedManager;
        this.config = config;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.config.getFeedingSystemEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (!(vehicle instanceof HappyGhast)) {
            return;
        }
        HappyGhast ghast = (HappyGhast)vehicle;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        boolean consumed = false;
        if (item.getType() == Material.SNOWBALL) {
            consumed = this.speedManager.feedSnowball(ghast, player);
        } else if (item.getType() == Material.FIRE_CHARGE) {
            consumed = this.speedManager.feedFireCharge(ghast, player);
        }
        if (consumed) {
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
            event.setCancelled(true);
        }
    }
}

