/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import ws.hypha.ghastmaster.config.DefaultConfig;

public class SpeedManager {
    private final Plugin plugin;
    private final DefaultConfig config;
    private final Map<UUID, SpeedData> ghastSpeeds = new HashMap<UUID, SpeedData>();
    private final Map<UUID, BukkitTask> speedTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> hudTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> particleTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Long> boostCooldowns = new HashMap<UUID, Long>();

    public SpeedManager(Plugin plugin, DefaultConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    public boolean feedSnowball(HappyGhast ghast, Player player) {
        UUID ghastId = ghast.getUniqueId();
        if (!this.canPlayerFeed(ghast, player)) {
            return false;
        }
        SpeedData speedData = this.ghastSpeeds.computeIfAbsent(ghastId, k -> new SpeedData());
        if (speedData.currentLevel >= 4) {
            return false;
        }
        speedData.setLevel(speedData.currentLevel + 1);
        this.applySpeed(ghast);
        this.scheduleSpeedDecrease(ghast, speedData.currentLevel);
        this.startHudUpdates(ghast);
        return true;
    }

    public boolean feedFireCharge(HappyGhast ghast, Player player) {
        UUID ghastId = ghast.getUniqueId();
        if (!this.canPlayerFeed(ghast, player)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Long lastBoostTime = this.boostCooldowns.get(ghastId);
        if (lastBoostTime != null) {
            long cooldownMs = (long)this.config.getBoostCooldown() * 1000L;
            if (currentTime - lastBoostTime < cooldownMs) {
                return false;
            }
        }
        SpeedData speedData = this.ghastSpeeds.computeIfAbsent(ghastId, k -> new SpeedData());
        speedData.setBoost(true);
        this.boostCooldowns.put(ghastId, currentTime);
        this.applySpeed(ghast);
        this.scheduleBoostEnd(ghast);
        this.startHudUpdates(ghast);
        this.startBoostParticles(ghast);
        return true;
    }

    private boolean canPlayerFeed(HappyGhast ghast, Player player) {
        if (this.config.getAnyPassengerCanFeed()) {
            return ghast.getPassengers().contains(player);
        }
        return !ghast.getPassengers().isEmpty() && ((Entity)ghast.getPassengers().get(0)).equals((Object)player);
    }

    private void scheduleSpeedDecrease(HappyGhast ghast, int level) {
        UUID ghastId = ghast.getUniqueId();
        BukkitTask existingTask = this.speedTasks.get(ghastId);
        if (existingTask != null) {
            existingTask.cancel();
        }
        int duration = this.config.getSpeedLevelDuration(level);
        BukkitTask task = Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            SpeedData speedData = this.ghastSpeeds.get(ghastId);
            if (speedData != null && speedData.currentLevel > 0) {
                speedData.setLevel(speedData.currentLevel - 1);
                this.applySpeed(ghast);
                if (speedData.currentLevel > 0) {
                    this.scheduleSpeedDecrease(ghast, speedData.currentLevel);
                } else {
                    this.stopHudUpdates(ghast);
                }
            }
        }, (long)duration * 20L);
        this.speedTasks.put(ghastId, task);
    }

    private void scheduleBoostEnd(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        int duration = this.config.getBoostDuration();
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            SpeedData speedData = this.ghastSpeeds.get(ghastId);
            if (speedData != null) {
                speedData.setBoost(false);
                this.applySpeed(ghast);
                if (speedData.currentLevel == 0) {
                    this.stopHudUpdates(ghast);
                }
                this.stopBoostParticles(ghast);
            }
        }, (long)duration * 20L);
    }

    private void startBoostParticles(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        BukkitTask existingTask = this.particleTasks.get(ghastId);
        if (existingTask != null) {
            existingTask.cancel();
        }
        BukkitTask particleTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            ghast.getWorld().spawnParticle(Particle.FLAME, ghast.getLocation().add(0.0, 0.5, 0.0), 10, 1.0, 0.5, 1.0, 0.05);
            ghast.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, ghast.getLocation().add(0.0, 0.5, 0.0), 5, 0.8, 0.3, 0.8, 0.02);
        }, 0L, 5L);
        this.particleTasks.put(ghastId, particleTask);
    }

    private void stopBoostParticles(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        BukkitTask particleTask = this.particleTasks.remove(ghastId);
        if (particleTask != null) {
            particleTask.cancel();
        }
    }

    public void applySpeed(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        SpeedData speedData = this.ghastSpeeds.computeIfAbsent(ghastId, k -> new SpeedData());
        int passengerCount = ghast.getPassengers().size();
        double baseSpeedPercent = passengerCount == 0 ? this.config.getHappyGhastIdleSpeedPercent() : this.config.getHappyGhastMountedSpeedPercent(passengerCount);
        double multiplierPercent = speedData.isBoosting ? this.config.getBoostSpeedPercent() : this.config.getSpeedLevelPercent(speedData.currentLevel);
        double finalSpeedPercent = baseSpeedPercent * multiplierPercent / 100.0;
        double defaultHappyGhastSpeed = 0.05;
        double speed = Math.max(0.0, Math.min(1.0, finalSpeedPercent / 100.0 * defaultHappyGhastSpeed));
        if (ghast.getAttribute(Attribute.FLYING_SPEED) != null) {
            ghast.getAttribute(Attribute.FLYING_SPEED).setBaseValue(speed);
        }
    }

    private void startHudUpdates(HappyGhast ghast) {
        if (!this.config.getHudSystemEnabled() || !this.config.getShowSpeedHud()) {
            return;
        }
        UUID ghastId = ghast.getUniqueId();
        BukkitTask existingTask = this.hudTasks.get(ghastId);
        if (existingTask != null) {
            existingTask.cancel();
        }
        int interval = this.config.getHudUpdateIntervalTicks();
        BukkitTask hudTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> this.updateHud(ghast), 0L, (long)interval);
        this.hudTasks.put(ghastId, hudTask);
    }

    private void stopHudUpdates(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        BukkitTask hudTask = this.hudTasks.remove(ghastId);
        if (hudTask != null) {
            hudTask.cancel();
        }
    }

    private void updateHud(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        SpeedData speedData = this.ghastSpeeds.get(ghastId);
        if (speedData == null) {
            return;
        }
        ghast.getPassengers().forEach(passenger -> {
            if (passenger instanceof Player) {
                Object hudText;
                Player player = (Player)passenger;
                if (speedData.isBoosting) {
                    hudText = String.valueOf(ChatColor.RED) + "\ud83d\udd25 " + String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "BOOST MODE" + String.valueOf(ChatColor.RED) + " \ud83d\udd25 " + String.valueOf(ChatColor.YELLOW) + "\u2726\u2726\u2726\u2726\u2726";
                } else if (speedData.currentLevel > 0) {
                    int i;
                    StringBuilder levelBar = new StringBuilder();
                    levelBar.append(ChatColor.AQUA).append("\u2744 Speed: ");
                    for (i = 0; i < speedData.currentLevel; ++i) {
                        levelBar.append(ChatColor.WHITE).append("\u2745");
                    }
                    for (i = speedData.currentLevel; i < 4; ++i) {
                        levelBar.append(ChatColor.DARK_GRAY).append("\u2745");
                    }
                    levelBar.append(ChatColor.AQUA).append(" (").append(speedData.currentLevel).append("/4)");
                    hudText = levelBar.toString();
                } else {
                    hudText = "";
                }
                try {
                    player.getClass().getMethod("sendActionBar", String.class).invoke((Object)player, hudText);
                }
                catch (Exception e1) {
                    try {
                        player.getClass().getMethod("spigot", new Class[0]).invoke((Object)player, new Object[0]).getClass().getMethod("sendMessage", Class.forName("net.md_5.bungee.api.ChatMessageType"), Class.forName("net.md_5.bungee.api.chat.BaseComponent")).invoke(player.getClass().getMethod("spigot", new Class[0]).invoke((Object)player, new Object[0]), Class.forName("net.md_5.bungee.api.ChatMessageType").getField("ACTION_BAR").get(null), Class.forName("net.md_5.bungee.api.chat.TextComponent").getConstructor(String.class).newInstance(hudText));
                    }
                    catch (Exception e2) {
                        player.sendTitle("", (String)hudText, 0, 20, 5);
                    }
                }
            }
        });
    }

    public void onVehicleEnter(HappyGhast ghast) {
        this.applySpeed(ghast);
        UUID ghastId = ghast.getUniqueId();
        SpeedData speedData = this.ghastSpeeds.get(ghastId);
        if (speedData != null && (speedData.currentLevel > 0 || speedData.isBoosting)) {
            this.startHudUpdates(ghast);
        }
    }

    public void onVehicleExit(HappyGhast ghast) {
        this.applySpeed(ghast);
        if (ghast.getPassengers().isEmpty()) {
            this.resetToIdle(ghast);
        }
    }

    private void resetToIdle(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        SpeedData speedData = this.ghastSpeeds.remove(ghastId);
        if (speedData != null) {
            BukkitTask particleTask;
            BukkitTask hudTask;
            BukkitTask speedTask = this.speedTasks.remove(ghastId);
            if (speedTask != null) {
                speedTask.cancel();
            }
            if ((hudTask = this.hudTasks.remove(ghastId)) != null) {
                hudTask.cancel();
            }
            if ((particleTask = this.particleTasks.remove(ghastId)) != null) {
                particleTask.cancel();
            }
        }
        double idleSpeedPercent = this.config.getHappyGhastIdleSpeedPercent();
        double defaultHappyGhastSpeed = 0.05;
        double speed = Math.max(0.0, Math.min(1.0, idleSpeedPercent / 100.0 * defaultHappyGhastSpeed));
        if (ghast.getAttribute(Attribute.FLYING_SPEED) != null) {
            ghast.getAttribute(Attribute.FLYING_SPEED).setBaseValue(speed);
        }
    }

    public void cleanup() {
        this.speedTasks.values().forEach(BukkitTask::cancel);
        this.hudTasks.values().forEach(BukkitTask::cancel);
        this.particleTasks.values().forEach(BukkitTask::cancel);
        this.speedTasks.clear();
        this.hudTasks.clear();
        this.particleTasks.clear();
        this.ghastSpeeds.clear();
        this.boostCooldowns.clear();
    }

    public static class SpeedData {
        private int currentLevel = 0;
        private boolean isBoosting = false;

        public void setLevel(int level) {
            this.currentLevel = Math.max(0, Math.min(4, level));
        }

        public void setBoost(boolean boosting) {
            this.isBoosting = boosting;
        }

        @Generated
        public int getCurrentLevel() {
            return this.currentLevel;
        }

        @Generated
        public boolean isBoosting() {
            return this.isBoosting;
        }
    }
}

