/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.config;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DefaultConfig {
    private static final String CONFIG = "Config.";
    private static final String PREFIX = "Config.Prefix.";
    private static final String SETTING = "Config.Settings.";
    private final JavaPlugin plugin;
    private FileConfiguration cfg;

    public DefaultConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.cfg = plugin.getConfig();
    }

    public String getPluginPrefix() {
        return this.cfg.getString("Config.Prefix.plugin-prefix", "&7[&6GhastMaster&7]&r ");
    }

    public String getMessage(TextKey textkey) {
        return this.cfg.getString(textkey.key, this.getDefaultMessage(textkey));
    }

    public String getMountInstructionsMessage() {
        String message = this.getMessage(TextKey.MOUNT_INSTRUCTIONS);
        if (message != null) {
            String speedItemName = this.getSpeedFeedItem().name().replace("_", " ").toLowerCase();
            String boostItemName = this.getBoostFeedItem().name().replace("_", " ").toLowerCase();
            message = message.replace("%SPEED_ITEM%", speedItemName);
            message = message.replace("%BOOST_ITEM%", boostItemName);
        }
        return message;
    }

    public double getHappyGhastMountedSpeedPercent(int passengerCount) {
        double defaultSpeed = Math.max(100.0, 200.0 - (double)passengerCount * 20.0);
        return this.cfg.getDouble(SETTING + passengerCount + "-passenger-happy-ghast-speed-percent", defaultSpeed);
    }

    public double getHappyGhastIdleSpeedPercent() {
        return this.cfg.getDouble("Config.Settings.idle-happy-ghast-speed-percent", 100.0);
    }

    public double getSpeedLevelPercent(int level) {
        if (level == 0) {
            return 100.0;
        }
        double defaultSpeed = 100.0 + (double)level * 50.0;
        return this.cfg.getDouble("Config.Settings.speed-level-" + level + "-percent", defaultSpeed);
    }

    public double getBoostSpeedPercent() {
        return this.cfg.getDouble("Config.Settings.boost-speed-percent", 500.0);
    }

    public int getSpeedLevelDuration(int level) {
        int defaultDuration = Math.max(10, 35 - level * 5);
        return this.cfg.getInt("Config.Settings.speed-level-" + level + "-duration", defaultDuration);
    }

    public int getBoostDuration() {
        return this.cfg.getInt("Config.Settings.boost-duration", 5);
    }

    public int getBoostCooldown() {
        return this.cfg.getInt("Config.Settings.boost-cooldown", 60);
    }

    public boolean getAnyPassengerCanFeed() {
        return this.cfg.getBoolean("Config.Settings.any-passenger-can-feed", true);
    }

    public Material getSpeedFeedItem() {
        String itemName = this.cfg.getString("Config.Settings.speed-feed-item", "SNOWBALL");
        try {
            return Material.valueOf((String)itemName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid speed-feed-item '" + itemName + "' in config. Using SNOWBALL.");
            return Material.SNOWBALL;
        }
    }

    public Material getBoostFeedItem() {
        String itemName = this.cfg.getString("Config.Settings.boost-feed-item", "FIRE_CHARGE");
        try {
            return Material.valueOf((String)itemName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid boost-feed-item '" + itemName + "' in config. Using FIRE_CHARGE.");
            return Material.FIRE_CHARGE;
        }
    }

    public boolean getShowSpeedHud() {
        return this.cfg.getBoolean("Config.Settings.show-speed-hud", true);
    }

    public int getHudUpdateIntervalTicks() {
        return this.cfg.getInt("Config.Settings.hud-update-interval-ticks", 20);
    }

    public boolean getShowMountInstructions() {
        return this.cfg.getBoolean("Config.Settings.show-mount-instructions", true);
    }

    public boolean getBuildOnHappyGhastEnabled() {
        return this.cfg.getBoolean("Config.Settings.build-on-happy-ghast-enabled", true);
    }

    public boolean getSpeedManagementEnabled() {
        return this.cfg.getBoolean("Config.Settings.speed-management-enabled", true);
    }

    public boolean getFeedingSystemEnabled() {
        return this.cfg.getBoolean("Config.Settings.feeding-system-enabled", true);
    }

    public boolean getHudSystemEnabled() {
        return this.cfg.getBoolean("Config.Settings.hud-system-enabled", true);
    }

    public boolean getParticleEffectsEnabled() {
        return this.cfg.getBoolean("Config.Settings.particle-effects-enabled", true);
    }

    public boolean getBypassSystemEnabled() {
        return this.cfg.getBoolean("Config.Settings.bypass-system-enabled", true);
    }

    public String getSpeedHudPrefix() {
        return this.cfg.getString("Config.Settings.speed-hud-prefix", "\u2744 Speed: ");
    }

    public String getSpeedHudFilledSymbol() {
        return this.cfg.getString("Config.Settings.speed-hud-filled-symbol", "\u2745");
    }

    public String getSpeedHudEmptySymbol() {
        return this.cfg.getString("Config.Settings.speed-hud-empty-symbol", "\u2745");
    }

    public ChatColor getSpeedHudFilledColor() {
        String colorName = this.cfg.getString("Config.Settings.speed-hud-filled-color", "WHITE");
        return this.getChatColor(colorName, ChatColor.WHITE);
    }

    public ChatColor getSpeedHudEmptyColor() {
        String colorName = this.cfg.getString("Config.Settings.speed-hud-empty-color", "DARK_GRAY");
        return this.getChatColor(colorName, ChatColor.DARK_GRAY);
    }

    public ChatColor getSpeedHudPrefixColor() {
        String colorName = this.cfg.getString("Config.Settings.speed-hud-prefix-color", "AQUA");
        return this.getChatColor(colorName, ChatColor.AQUA);
    }

    public ChatColor getSpeedHudSuffixColor() {
        String colorName = this.cfg.getString("Config.Settings.speed-hud-suffix-color", "AQUA");
        return this.getChatColor(colorName, ChatColor.AQUA);
    }

    public String getBoostHudPrefix() {
        return this.cfg.getString("Config.Settings.boost-hud-prefix", "\u2b50 Boost: ");
    }

    public String getBoostHudSymbol() {
        return this.cfg.getString("Config.Settings.boost-hud-symbol", "\u25cf");
    }

    public ChatColor getBoostHudPrefixColor() {
        String colorName = this.cfg.getString("Config.Settings.boost-hud-prefix-color", "GOLD");
        return this.getChatColor(colorName, ChatColor.GOLD);
    }

    public ChatColor getBoostHudSymbolColor() {
        String colorName = this.cfg.getString("Config.Settings.boost-hud-symbol-color", "YELLOW");
        return this.getChatColor(colorName, ChatColor.YELLOW);
    }

    public ChatColor getBoostHudSuffixColor() {
        String colorName = this.cfg.getString("Config.Settings.boost-hud-suffix-color", "GOLD");
        return this.getChatColor(colorName, ChatColor.GOLD);
    }

    private ChatColor getChatColor(String colorName, ChatColor defaultColor) {
        if (colorName == null) {
            return defaultColor;
        }
        try {
            return ChatColor.valueOf((String)colorName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid color '" + colorName + "' in config. Using default.");
            return defaultColor;
        }
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.cfg.getBoolean(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.cfg.getDouble(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public String getText(String path) {
        return this.cfg.getString("Config.Messages." + path);
    }

    public long getLong(String path, long defaultValue) {
        return this.cfg.getLong(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.cfg.getInt(SETTING + path.replace("Settings.", ""), defaultValue);
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.cfg = this.plugin.getConfig();
    }

    private String getDefaultMessage(TextKey textkey) {
        return switch (textkey.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "%PREFIX%&aConfiguration reloaded!";
            case 1 -> "%PREFIX%&c\u2717 Access denied! This Happy Ghast belongs to &e%OWNER%&c.";
            case 2 -> "%PREFIX%&a\u2713 Bypassed ownership protection (belongs to &e%OWNER%&a).";
            case 3 -> "%PREFIX%&c\u2717 This Happy Ghast is already owned by someone else!";
            case 4 -> "%PREFIX%&a\u2713 You have claimed ownership of this Happy Ghast!";
            case 5 -> "%PREFIX%&a\u2713 Happy Ghast successfully tamed! You are now the owner.";
            case 6 -> "%PREFIX%&7\u26a0 Harness removed, but you still own this Happy Ghast.";
            case 7 -> "%PREFIX%&c\u2717 You don't have permission to tame Happy Ghasts!";
            case 8 -> "%PREFIX%&c\u2717 Cannot remove harness while passengers are aboard!";
            case 9 -> "%PREFIX%&a\u2713 Free mode activated! Right-click a Happy Ghast to mark it as free.";
            case 10 -> "%PREFIX%&7\u26a0 Free mode timed out.";
            case 11 -> "%PREFIX%&a\u2713 Happy Ghast marked as free! Anyone can now use it.";
            case 12 -> "%PREFIX%&7\u26a0 This Happy Ghast is already free.";
            case 13 -> "%PREFIX%&c\u2717 You cannot free this Happy Ghast.";
            case 14 -> "%PREFIX%&a\u2713 Happy Ghast harnessed and marked as free for everyone!";
            case 15 -> "%PREFIX%&c\u2717 You don't have permission to use free mode!";
            case 16 -> "%PREFIX%&c\u2717 This command can only be used by players!";
            case 17 -> "%PREFIX%&e\u26a1 Mount successful! &7Left-click with &f%SPEED_ITEM% &7to increase speed, &6%BOOST_ITEM% &7for boost mode!";
            case 18 -> "%PREFIX%&7\u26a0 Ownership system is currently disabled.";
            case 19 -> "%PREFIX%&c\u2717 You don't have permission to unclaim Happy Ghasts!";
            case 20 -> "%PREFIX%&c\u2717 You don't have permission to force unclaim Happy Ghasts!";
            case 21 -> "%PREFIX%&c\u2717 No Happy Ghast found in your line of sight!";
            case 22 -> "%PREFIX%&c\u2717 You can only unclaim your own Happy Ghasts!";
            case 23 -> "%PREFIX%&c\u2717 Cannot unclaim a free Happy Ghast!";
            case 24 -> "%PREFIX%&7\u26a0 This Happy Ghast is already unclaimed.";
            case 25 -> "%PREFIX%&c\u2717 You cannot unclaim this Happy Ghast.";
            case 26 -> "%PREFIX%&a\u2713 Happy Ghast unclaimed successfully!";
            case 27 -> "%PREFIX%&a\u2713 Happy Ghast force unclaimed by admin!";
            case 28 -> "%PREFIX%&a\u2713 Unclaim mode activated! Right-click your Happy Ghast to unclaim it.";
            case 29 -> "%PREFIX%&c\u26a0 Admin unclaim mode activated! Right-click any Happy Ghast to force unclaim it.";
            case 30 -> "%PREFIX%&7\u26a0 Unclaim mode timed out.";
            case 31 -> "%PREFIX%&c\u26a0 Right-click again within 5 seconds to confirm force unclaim.";
            case 32 -> "%PREFIX%&7\u26a0 No pending unclaim operation.";
            case 33 -> "%PREFIX%&c\u2717 The Happy Ghast no longer exists.";
        };
    }

    public static enum TextKey {
        RELOADED_CONFIG("reloaded-config"),
        UNAUTHORIZED_ACCESS("unauthorized-access"),
        BYPASS_MOUNT_SUCCESS("bypass-mount-success"),
        GHAST_ALREADY_HARNESSED("ghast-already-harnessed"),
        GHAST_OWNERSHIP_CLAIMED("ghast-ownership-claimed"),
        GHAST_OWNERSHIP_GAINED("ghast-ownership-gained"),
        GHAST_OWNERSHIP_REMOVED("ghast-ownership-removed"),
        NO_PERMISSION_HARNESS("no-permission-harness"),
        CANNOT_REMOVE_HARNESS_WITH_PASSENGERS("cannot-remove-harness-with-passengers"),
        FREE_MODE_ENTERED("free-mode-entered"),
        FREE_MODE_TIMEOUT("free-mode-timeout"),
        GHAST_FREED_SUCCESS("ghast-freed-success"),
        GHAST_ALREADY_FREE("ghast-already-free"),
        CANNOT_FREE_GHAST("cannot-free-ghast"),
        GHAST_HARNESSED_FREE("ghast-harnessed-free"),
        NO_PERMISSION_FREE("no-permission-free"),
        COMMAND_PLAYERS_ONLY("command-players-only"),
        MOUNT_INSTRUCTIONS("mount-instructions"),
        OWNERSHIP_SYSTEM_DISABLED("ownership-system-disabled"),
        NO_PERMISSION_UNCLAIM("no-permission-unclaim"),
        NO_PERMISSION_UNCLAIM_ADMIN("no-permission-unclaim-admin"),
        NO_GHAST_IN_SIGHT("no-ghast-in-sight"),
        CANNOT_UNCLAIM_NOT_OWNER("cannot-unclaim-not-owner"),
        CANNOT_UNCLAIM_FREE_GHAST("cannot-unclaim-free-ghast"),
        GHAST_ALREADY_UNCLAIMED("ghast-already-unclaimed"),
        CANNOT_UNCLAIM_GHAST("cannot-unclaim-ghast"),
        GHAST_UNCLAIMED_SUCCESS("ghast-unclaimed-success"),
        GHAST_ADMIN_UNCLAIMED_SUCCESS("ghast-admin-unclaimed-success"),
        UNCLAIM_MODE_ENTERED("unclaim-mode-entered"),
        ADMIN_UNCLAIM_MODE_ENTERED("admin-unclaim-mode-entered"),
        UNCLAIM_MODE_TIMEOUT("unclaim-mode-timeout"),
        ADMIN_UNCLAIM_CONFIRMATION_REQUIRED("admin-unclaim-confirmation-required"),
        NO_PENDING_UNCLAIM("no-pending-unclaim"),
        GHAST_NO_LONGER_EXISTS("ghast-no-longer-exists");

        private final String key;

        private TextKey(String key) {
            this.key = "Config.Messages." + key;
        }
    }
}

