/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.utils.MessageSender;

public class FreeModeManager {
    private final Plugin plugin;
    private final DefaultConfig config;
    private final MessageSender messageSender;
    private final Map<UUID, BukkitTask> playersInFreeMode = new HashMap<UUID, BukkitTask>();

    public void enterFreeMode(Player player) {
        UUID playerId = player.getUniqueId();
        this.exitFreeMode(player);
        BukkitTask timeoutTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            this.exitFreeMode(player);
            this.messageSender.sendMessage((CommandSender)player, this.config.getText("free-mode-timeout"));
        }, this.config.getLong("free-mode-timeout-ticks", 600L));
        this.playersInFreeMode.put(playerId, timeoutTask);
        this.messageSender.sendMessage((CommandSender)player, this.config.getText("free-mode-entered"));
    }

    public void exitFreeMode(Player player) {
        UUID playerId = player.getUniqueId();
        BukkitTask task = this.playersInFreeMode.remove(playerId);
        if (task != null) {
            task.cancel();
        }
    }

    public boolean isInFreeMode(Player player) {
        return this.playersInFreeMode.containsKey(player.getUniqueId());
    }

    public void cleanup() {
        for (BukkitTask task : this.playersInFreeMode.values()) {
            if (task == null) continue;
            task.cancel();
        }
        this.playersInFreeMode.clear();
    }

    @Generated
    public FreeModeManager(Plugin plugin, DefaultConfig config, MessageSender messageSender) {
        this.plugin = plugin;
        this.config = config;
        this.messageSender = messageSender;
    }
}

