/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ws.hypha.ghastmaster.config.DefaultConfig;

public class BuildListener
implements Listener {
    private DefaultConfig config;
    private Plugin plugin;

    @EventHandler
    private void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        BlockStateMeta blockStateMeta;
        ItemMeta itemMeta;
        Location entLoc;
        Location placeLoc;
        Player player = event.getPlayer();
        if (!this.config.getBuildOnHappyGhastEnabled()) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!(ent instanceof HappyGhast)) {
            return;
        }
        HappyGhast ghast = (HappyGhast)ent;
        GameMode gameMode = player.getGameMode();
        if (gameMode != GameMode.SURVIVAL && gameMode != GameMode.CREATIVE) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Material mat = item.getType();
        EquipmentSlot slot = EquipmentSlot.HAND;
        if (mat.isAir() || !mat.isBlock() || !mat.isSolid()) {
            item = player.getInventory().getItemInOffHand();
            mat = item.getType();
            if (mat.isAir() || !mat.isBlock() || !mat.isSolid()) {
                return;
            }
            slot = EquipmentSlot.OFF_HAND;
        }
        if ((double)((placeLoc = (entLoc = ent.getLocation()).clone().add(event.getClickedPosition())).getBlockY() - entLoc.getBlockY()) < ent.getHeight()) {
            return;
        }
        if (entLoc.getY() != (double)entLoc.getBlockY()) {
            placeLoc.add(0.0, 1.0, 0.0);
        }
        BlockStateMeta nbtMeta = null;
        if (item.hasItemMeta() && (itemMeta = item.getItemMeta()) instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)itemMeta).hasBlockState()) {
            nbtMeta = blockStateMeta;
        }
        Vector playerEyes = player.getEyeLocation().toVector();
        Vector relative = playerEyes.subtract(placeLoc.toVector());
        BlockFace face = this.getDominantFace(relative);
        Block blockToSet = placeLoc.getBlock();
        if (!blockToSet.getType().isAir()) {
            return;
        }
        this.placeBlockWithBlockPlaceEvent(player, blockToSet, face, item, slot, nbtMeta);
        event.setCancelled(true);
    }

    private void placeBlockWithBlockPlaceEvent(Player player, Block block, BlockFace face, ItemStack placedItem, EquipmentSlot slot, BlockStateMeta nbtMeta) {
        BlockState replacedState = block.getState();
        BlockPlaceEvent placeEvent = new BlockPlaceEvent(block, replacedState, block.getRelative(face), placedItem.clone(), player, true, slot);
        Bukkit.getPluginManager().callEvent((Event)placeEvent);
        if (placeEvent.isCancelled()) {
            return;
        }
        if (nbtMeta != null) {
            block.setType(placedItem.getType(), false);
            BlockState sourceState = nbtMeta.getBlockState();
            BlockState targetState = block.getState();
            if (sourceState instanceof Container && targetState instanceof Container) {
                targetState = sourceState.copy(block.getLocation());
                targetState.update(true, false);
            }
        } else {
            block.setType(placedItem.getType(), false);
        }
        BlockData data = block.getBlockData();
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            if (!block.getType().name().contains("SHULKER_BOX") && (face = face.getOppositeFace()) != BlockFace.UP && face != BlockFace.DOWN) {
                directional.setFacing(face);
                block.setBlockData(data, true);
            }
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            placedItem.setAmount(placedItem.getAmount() - 1);
        }
    }

    private BlockFace getDominantFace(Vector vec) {
        BlockFace bestFace = BlockFace.DOWN;
        double bestDot = -1.0;
        for (BlockFace face : BlockFace.values()) {
            if (!face.isCartesian()) continue;
            Vector dir = face.getDirection();
            double dot = vec.clone().normalize().dot(dir);
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            bestFace = face;
        }
        return bestFace;
    }

    @Generated
    public BuildListener(DefaultConfig config, Plugin plugin) {
        this.config = config;
        this.plugin = plugin;
    }
}

