/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.SpeedManager;

public class FeedingListener
implements Listener {
    private final SpeedManager speedManager;
    private final DefaultConfig config;
    private final Map<UUID, Long> recentRightClicks = new HashMap<UUID, Long>();
    private final Material speedItem;
    private final Material boostItem;

    public FeedingListener(SpeedManager speedManager, DefaultConfig config) {
        this.speedManager = speedManager;
        this.config = config;
        this.speedItem = config.getSpeedFeedItem();
        this.boostItem = config.getBoostFeedItem();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long timeSinceRightClick;
        if (!this.config.getFeedingSystemEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (item != null && (item.getType() == this.speedItem || item.getType() == this.boostItem)) {
                this.recentRightClicks.put(player.getUniqueId(), System.currentTimeMillis());
            }
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        Long lastRightClick = this.recentRightClicks.get(player.getUniqueId());
        if (lastRightClick != null && (timeSinceRightClick = System.currentTimeMillis() - lastRightClick) < 100L) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (!(vehicle instanceof HappyGhast)) {
            return;
        }
        HappyGhast ghast = (HappyGhast)vehicle;
        item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        boolean consumed = false;
        if (item.getType() == this.speedItem) {
            consumed = this.speedManager.feedSnowball(ghast, player);
        } else if (item.getType() == this.boostItem) {
            consumed = this.speedManager.feedFireCharge(ghast, player);
        }
        if (consumed) {
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof HappyGhast)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && (item.getType() == this.speedItem || item.getType() == this.boostItem)) {
            this.recentRightClicks.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }
}

