/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.listeners;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.OwnershipManager;
import ws.hypha.ghastmaster.managers.SpeedManager;
import ws.hypha.ghastmaster.utils.MessageSender;

public class VehicleListener
implements Listener {
    private final Plugin plugin;
    private final SpeedManager speedManager;
    private final OwnershipManager ownershipManager;
    private final MessageSender messageSender;
    private final DefaultConfig config;

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onVehicleEnter(VehicleEnterEvent event) {
        String instructions;
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof HappyGhast)) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)vehicle;
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleEnter(happyGhast));
            return;
        }
        Player player = (Player)entity;
        boolean isFirstMount = happyGhast.getPassengers().isEmpty();
        if (this.config.getBypassSystemEnabled() && this.ownershipManager.isOwnershipEnabled() && this.ownershipManager.isOwned(happyGhast) && isFirstMount && !this.ownershipManager.isOwner(happyGhast, player)) {
            if (!player.hasPermission("ghastmaster.bypass") && !player.isOp()) {
                this.ownershipManager.handleUnauthorizedAccess(happyGhast, player, "mount");
                event.setCancelled(true);
                return;
            }
            String ownerName = this.ownershipManager.getOwnerName(happyGhast);
            String message = this.config.getMessage(DefaultConfig.TextKey.BYPASS_MOUNT_SUCCESS);
            if (message != null) {
                message = message.replace("%OWNER%", ownerName != null ? ownerName : "Unknown");
                this.messageSender.sendMessage((CommandSender)player, message);
            }
        }
        if (isFirstMount && this.config.getFeedingSystemEnabled() && this.config.getShowMountInstructions() && (instructions = this.config.getMountInstructionsMessage()) != null) {
            this.messageSender.sendMessage((CommandSender)player, instructions);
        }
        if (this.config.getSpeedManagementEnabled()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleEnter(happyGhast));
        }
    }

    @EventHandler
    private void onVehicleExit(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof HappyGhast)) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)vehicle;
        LivingEntity livingEntity = event.getExited();
        if (!(livingEntity instanceof Player)) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleExit(happyGhast));
            return;
        }
        Player exitingPlayer = (Player)livingEntity;
        if (this.config.getBypassSystemEnabled() && this.ownershipManager.isOwnershipEnabled() && this.ownershipManager.isOwned(happyGhast) && this.config.getEjectPassengersOnOwnerDismount() && this.ownershipManager.isOwner(happyGhast, exitingPlayer)) {
            happyGhast.getPassengers().stream().filter(passenger -> passenger instanceof Player).map(passenger -> (Player)passenger).filter(passenger -> !passenger.equals((Object)exitingPlayer)).forEach(passenger -> {
                if (!passenger.hasPermission("ghastmaster.bypass") && !passenger.isOp()) {
                    Bukkit.getScheduler().runTask(this.plugin, () -> {
                        String ejectionMessage;
                        happyGhast.removePassenger((Entity)passenger);
                        Location passengerLoc = passenger.getLocation();
                        passenger.teleport(passengerLoc.add(0.0, 0.1, 0.0));
                        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                            for (Player nearbyPlayer : happyGhast.getWorld().getPlayers()) {
                                if (!(nearbyPlayer.getLocation().distance(passenger.getLocation()) <= 64.0)) continue;
                                nearbyPlayer.hidePlayer(this.plugin, passenger);
                                nearbyPlayer.showPlayer(this.plugin, passenger);
                            }
                        }, 1L);
                        if (this.config.getShowEjectionMessage() && (ejectionMessage = this.config.getMessage(DefaultConfig.TextKey.PASSENGERS_EJECTED_OWNER_DISMOUNT)) != null) {
                            this.messageSender.sendMessage((CommandSender)passenger, ejectionMessage);
                        }
                    });
                }
            });
        }
        if (this.config.getSpeedManagementEnabled()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.speedManager.onVehicleExit(happyGhast));
        }
    }

    @Generated
    public VehicleListener(Plugin plugin, SpeedManager speedManager, OwnershipManager ownershipManager, MessageSender messageSender, DefaultConfig config) {
        this.plugin = plugin;
        this.speedManager = speedManager;
        this.ownershipManager = ownershipManager;
        this.messageSender = messageSender;
        this.config = config;
    }
}

