/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.ghastmaster.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.HappyGhast;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import ws.hypha.ghastmaster.config.DefaultConfig;
import ws.hypha.ghastmaster.managers.OwnershipManager;

public class ParticleManager {
    private final Plugin plugin;
    private final DefaultConfig config;
    private final OwnershipManager ownershipManager;
    private final Map<UUID, BukkitTask> particleTasks = new HashMap<UUID, BukkitTask>();

    public void startFreeGhastParticles(final HappyGhast ghast) {
        if (!this.config.getParticleEffectsEnabled()) {
            return;
        }
        final UUID ghastId = ghast.getUniqueId();
        this.stopFreeGhastParticles(ghast);
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (!ghast.isValid() || ghast.isDead() || !ParticleManager.this.ownershipManager.isFree(ghast)) {
                    this.cancel();
                    ParticleManager.this.particleTasks.remove(ghastId);
                    return;
                }
                Location location = ghast.getLocation().add(0.0, 1.0, 0.0);
                if (Math.random() < ParticleManager.this.config.getDouble("free-ghast-particle-chance", 0.3)) {
                    for (int i = 0; i < ParticleManager.this.config.getInt("free-ghast-particle-count", 2); ++i) {
                        double offsetX = (Math.random() - 0.5) * 2.0;
                        double offsetY = Math.random() * 1.5;
                        double offsetZ = (Math.random() - 0.5) * 2.0;
                        Location particleLocation = location.clone().add(offsetX, offsetY, offsetZ);
                        ghast.getWorld().spawnParticle(Particle.HEART, particleLocation, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }.runTaskTimer(this.plugin, 0L, this.config.getLong("free-ghast-particle-interval-ticks", 40L));
        this.particleTasks.put(ghastId, task);
    }

    public void stopFreeGhastParticles(HappyGhast ghast) {
        UUID ghastId = ghast.getUniqueId();
        BukkitTask task = this.particleTasks.remove(ghastId);
        if (task != null) {
            task.cancel();
        }
    }

    public void cleanupInvalidTasks() {
        this.particleTasks.entrySet().removeIf(entry -> {
            BukkitTask task = (BukkitTask)entry.getValue();
            if (task.isCancelled()) {
                return true;
            }
            try {
                HappyGhast ghast = (HappyGhast)Bukkit.getEntity((UUID)((UUID)entry.getKey()));
                if (ghast == null || !ghast.isValid() || ghast.isDead() || !this.ownershipManager.isFree(ghast)) {
                    task.cancel();
                    return true;
                }
            }
            catch (Exception e) {
                task.cancel();
                return true;
            }
            return false;
        });
    }

    public void cleanup() {
        for (BukkitTask task : this.particleTasks.values()) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.particleTasks.clear();
    }

    @Generated
    public ParticleManager(Plugin plugin, DefaultConfig config, OwnershipManager ownershipManager) {
        this.plugin = plugin;
        this.config = config;
        this.ownershipManager = ownershipManager;
    }
}

